from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from 'ready-pose' to 'drawer-area'
        # If either is missing from Object, raise informative error
        ready_pose = Object.get("ready-pose")
        drawer_area = Object.get("drawer-area")
        if ready_pose is None or drawer_area is None:
            raise ValueError("Missing required location: 'ready-pose' or 'drawer-area' in Object list.")
        # execute_go: Move robot to drawer area (mode=7)
        # The go skill ignores the actual pose, but to keep consistent, pass pose0 as ready_pose and pose1 as drawer_area
        robot.execute_movement(pose0=ready_pose, pose1=drawer_area, mode=7)

        # Step 2: Pick up 'handle_bottom' at 'drawer-area' (axis=0 for handles)
        handle_bottom = Object.get("drawer_bottom_handle") or Object.get("handle_bottom")
        if handle_bottom is None:
            raise ValueError("Missing required handle object: 'drawer_bottom_handle' or 'handle_bottom' in Object list.")
        robot.execute_movement(handle_bottom, mode=1, axis=0)  # mode=1: pick

        # Step 3: Pull to open 'drawer_bottom' using its handle at 'drawer-area' (axis=0 for handles)
        drawer_bottom = Object.get("drawer_bottom")
        if drawer_bottom is None:
            raise ValueError("Missing required drawer object: 'drawer_bottom' in Object list.")
        # For pulling a drawer, use handle's pose to guide the action, mode=4 (pull)
        robot.execute_movement(handle_bottom, mode=4, axis=0, distance=0.1)

        # Step 4: Pick up 'handle_top' at 'drawer-area' (axis=0 for handles)
        handle_top = Object.get("drawer_top_handle") or Object.get("handle_top")
        if handle_top is None:
            raise ValueError("Missing required handle object: 'drawer_top_handle' or 'handle_top' in Object list.")
        robot.execute_movement(handle_top, mode=1, axis=0)  # mode=1: pick

        # Step 5: Pull to open 'drawer_top' using its handle at 'drawer-area' (axis=0 for handles)
        drawer_top = Object.get("drawer_top")
        if drawer_top is None:
            raise ValueError("Missing required drawer object: 'drawer_top' in Object list.")
        robot.execute_movement(handle_top, mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()