from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the bottom handle (handle_bottom at ready-pose) along x-axis
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pick on drawer_bottom_handle: {e}")

    # Step 2: Pull to uncover (open) the bottom drawer (drawer_bottom via handle_bottom at ready-pose) along x-axis, with a longer pull
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pull on drawer_bottom_handle: {e}")

    # Step 3: Pick the top handle (handle_top at ready-pose) along x-axis
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pick on drawer_top_handle: {e}")

    # Step 4: Pull to uncover (open) the top drawer (drawer_top via handle_top at ready-pose) along x-axis, with a longer pull
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pull on drawer_top_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
