from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # Step 1: execute_pick handle_bottom at ready-pose (axis=0: for handle pick, approach along x)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_bottom_handle: {e}")
    
    # Step 2: execute_pull drawer_bottom with handle_bottom at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom_handle: {e}")
    
    # Step 3: execute_go from ready-pose to ready-pose (The parameter '' seems to be a placeholder; stay in ready-pose)
    try:
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error in execute_go: {e}")
    
    # Step 4: execute_pick handle_top at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_top_handle: {e}")
    
    # Step 5: execute_pull drawer_top with handle_top at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull for drawer_top_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()