from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move from ready-pose to drawer-area using execute_go
    try:
        # execute_go expects (from, to)
        robot.execute_movement((Object["ready_pose"], Object["drawer_area"]), mode=7)
    except Exception as e:
        print(f"[ERROR] Failed to execute_go from ready-pose to drawer-area: {e}")

    # Step 2: Pick handle_bottom at drawer-area (approach x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pick on handle_bottom: {e}")

    # Step 3: Pull to open drawer_bottom using handle_bottom at drawer-area (approach x-axis)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pull on drawer_bottom: {e}")

    # Step 4: Pick handle_top at drawer-area (approach x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pick on handle_top: {e}")

    # Step 5: Pull to open drawer_top using handle_top at drawer-area (approach x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"[ERROR] Failed to execute_pull on drawer_top: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
