from pick_and_place_module.skills import PrimitiveSkill


class RobotController:
    def __init__(self, velocity=0.002, acceleration=0.4):
        self.primitive_skill = PrimitiveSkill(velocity, acceleration)

    # =========================
    # === Utility Functions ===
    # =========================

    def execute_movement(self, pose0=None, pose1=None, mode=0, gripper_force=80, axis=0, distance=0.03):

        if mode <8:
            target_x, target_y, target_z, target_roll, target_pitch, target_yaw = pose0
            self.primitive_skill.setTargetPose(target_x, target_y, target_z, 
                                             target_roll, target_pitch, target_yaw)

        movement_modes = {
            0: lambda: self._execute_pick_and_place(pose0, pose1, gripper_force, axis),
            1: lambda: self.primitive_skill.execute_pick(gripper_force=gripper_force, axis=axis),
            2: lambda: self.primitive_skill.execute_place(axis=axis),
            3: lambda: self.primitive_skill.execute_push(gripper_force=gripper_force, axis=axis, distance=distance),
            4: lambda: self.primitive_skill.execute_pull(gripper_force=gripper_force, axis=axis, distance=distance),
            5: lambda: self.primitive_skill.execute_sweep(axis=axis, distance=distance),
            6: lambda: self.primitive_skill.execute_rotate(gripper_force=gripper_force, axis=axis),
            7: lambda: self.primitive_skill.execute_go(),
            8: lambda: self.primitive_skill.go_to_ready_pose(),
            9: lambda: self.primitive_skill.execute_gripper(0.1, 0), # open
            10: lambda: self.primitive_skill.execute_gripper(0.00, gripper_force) # close
        }

        if mode in movement_modes:
            movement_modes[mode]()
