"""Module to pull open a pair of drawers using the robot controller."""

from object_list import Object
from skill_mapping import RobotController

def pull_open_pair_of_drawers():
    """Pull open any two drawers."""
    robot = RobotController()
    drawers_to_open = [
        ("drawer_bottom_handle",),
        ("drawer_middle_handle",)
    ]
    for handle_name_tuple in drawers_to_open:
        handle_name = handle_name_tuple[0]
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        robot.execute_movement(Object[handle_name], mode=4, distance=0.1)

def main():
    """Main entry point to pull open a pair of drawers."""
    pull_open_pair_of_drawers()

if __name__ == "__main__":
    main()