"""Module to open all unlocked drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def open_all_unlocked_drawers():
    """Open all unlocked drawers by picking their handles and pulling them open."""
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_bottom", "handle": "drawer_bottom_handle"},
        {"drawer": "drawer_middle", "handle": "drawer_middle_handle"},
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
    ]

    for item in drawers:
        drawer_name = item["drawer"]
        handle_name = item["handle"]

        # Check if the drawer is unlocked before attempting to open
        if robot.is_drawer_unlocked(drawer_name):
            # Pick the handle
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Pull the drawer open using the handle
            robot.execute_movement(Object[handle_name], mode=4, distance=0.1)

def main():
    """Main function to execute the task of opening all unlocked drawers."""
    open_all_unlocked_drawers()

if __name__ == "__main__":
    main()