"""Module to slide open any two drawers using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def slide_open_two_drawers():
    """Slides open any two drawers."""
    robot = RobotController()
    # List of available drawers and their handles
    drawers = [
        ("drawer_bottom_handle", "drawer_bottom"),
        ("drawer_middle_handle", "drawer_middle"),
        ("drawer_top_handle", "drawer_top"),
    ]
    opened = 0
    for handle_name, drawer_name in drawers:
        try:
            # Pick the handle
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Pull the drawer open
            robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
            opened += 1
            if opened == 2:
                break
        except Exception as error:
            continue

def main():
    """Main entry point to slide open two drawers."""
    slide_open_two_drawers()

if __name__ == "__main__":
    main()