"""Module to uncover every drawer that isn’t locked by opening only unlocked drawers."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Open every drawer that is not locked."""
    robot = RobotController()

    # List of drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_bottom", "handle": "drawer_bottom_handle"},
        {"drawer": "drawer_middle", "handle": "drawer_middle_handle"},
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
    ]

    for item in drawers:
        drawer_name = item["drawer"]
        handle_name = item["handle"]

        # Check if the drawer is unlocked before attempting to open
        try:
            if robot.get_drawer_state(drawer_name) == "unlocked":
                # Pick the handle
                robot.execute_movement(Object[handle_name], mode=1, axis=0)
                # Pull the drawer open
                robot.execute_movement(Object[handle_name], mode=4, distance=0.1)
        except Exception as error:
            print(f"Error while processing {drawer_name}: {error}")

def main():
    """Main entry point to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()