"""Module to slide open any two drawers using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Slides open any two drawers."""
    robot = RobotController()
    drawer_handles = [
        "drawer_bottom_handle",
        "drawer_middle_handle",
        "drawer_top_handle"
    ]
    drawers_opened = 0

    for handle_name in drawer_handles:
        try:
            # Pick the handle at ready-pose (axis=0 for handle)
            robot.execute_movement(Object[handle_name], mode=1, axis=0)
            # Unlock the drawer (mode=3 for unlock, axis=0)
            robot.execute_movement(Object[handle_name], mode=3, axis=0)
            # Pull the drawer using the handle (mode=4, axis=0, distance=0.1 for full pull)
            robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)
            drawers_opened += 1
            if drawers_opened == 2:
                break
        except Exception as error:
            print(f"Error during task execution: {error}")
            break

def main():
    """Main entry point to execute the drawer opening task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()