from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Pull open a pair of drawers (any two that are possible to open)."""
    robot = RobotController()
    try:
        # Open top drawer if possible
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1)
        # Open bottom drawer if possible
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for pulling open a pair of drawers."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()