from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Uncover every drawer that isn’t locked.
    """
    robot = RobotController()

    # List of all drawers and their corresponding handles
    drawers = [
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
        {"drawer": "drawer_middle", "handle": "drawer_middle_handle"},
        {"drawer": "drawer_bottom", "handle": "drawer_bottom_handle"},
    ]

    # Initial state: which drawers are unlocked and closed
    # In a real scenario, this would be queried from the environment or passed as arguments
    # For this problem, we hardcode based on the provided (:init ...)
    unlocked_and_closed_drawers = [
        {"drawer": "drawer_top", "handle": "drawer_top_handle"},
        # drawer_middle is locked, so skip
        # drawer_bottom is not mentioned in init, so assume it's not present or not unlocked
    ]

    # Move to drawer-area from ready-pose
    robot.execute_movement(mode=7)

    for item in unlocked_and_closed_drawers:
        handle_name = item["handle"]
        # Pick the handle (approach axis=0)
        robot.execute_movement(Object[handle_name], mode=1, axis=0)
        # Pull the drawer using the handle (mode=4, axis=0, distance=0.1)
        robot.execute_movement(Object[handle_name], mode=4, axis=0, distance=0.1)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()