from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence to uncover every drawer that isn’t locked.
    Plan (from spec):
      1) Pick handle_bottom at ready-pose (execute_pick)
      2) Pull drawer_bottom with handle_bottom at ready-pose (execute_pull)
      3) Pick handle_top at ready-pose (execute_pick)
      4) Pull drawer_top with handle_top at ready-pose (execute_pull)

    Axis guideline:
      - When grasping handles, approach along x-axis (axis=0)
      - execute_pick: mode=1
      - execute_pull: mode=4, distance=0.1

    Exception handling: If there is a KeyError, show which object is missing and continue (or break).
                      If there is a TypeError, show message and break.
    """

    robot = RobotController()

    # Step 1: Pick handle_bottom at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except KeyError as e:
        print(f"Error: Object {e} not found in Object list for execute_pick (handle_bottom).")
        return
    except Exception as e:
        print(f"Exception during execute_pick for handle_bottom: {e}")
        return

    # Step 2: Pull drawer_bottom using handle_bottom at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except KeyError as e:
        print(f"Error: Object {e} not found in Object list for execute_pull (drawer_bottom).")
        return
    except Exception as e:
        print(f"Exception during execute_pull for drawer_bottom: {e}")
        return

    # Step 3: Pick handle_top at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except KeyError as e:
        print(f"Error: Object {e} not found in Object list for execute_pick (handle_top).")
        return
    except Exception as e:
        print(f"Exception during execute_pick for handle_top: {e}")
        return

    # Step 4: Pull drawer_top using handle_top at ready-pose (axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except KeyError as e:
        print(f"Error: Object {e} not found in Object list for execute_pull (drawer_top).")
        return
    except Exception as e:
        print(f"Exception during execute_pull for drawer_top: {e}")
        return


def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
