from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from ready-pose (axis=2 for general objects)
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Ensure robot is at ready pose if needed

        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Redundant, but ensures ready pose

        # The actual pick: dice1 is assumed to be at ready-pose (on the floor)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)

        # Step 2: Place dice1 into the already open drawer1 at ready-pose (axis=2 for general objects)
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)

        # Optionally, return to ready pose
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()