from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick up dice1 from ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Ensure robot is at ready pose
    except Exception:
        pass  # If already at ready pose, ignore

    try:
        robot.execute_movement(Object["yellow_dice"], mode=1, axis=2)  # execute_pick: pick dice1 (yellow_dice) from ready-pose, approach along z-axis
    except Exception as e:
        print(f"Error during execute_pick: {e}")

    try:
        robot.execute_movement(mode=8)  # Move to ready pose after pick
    except Exception:
        pass

    # Step 2: Place dice1 into drawer1 at ready-pose
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place: place dice1 into drawer1, approach along z-axis
    except Exception as e:
        print(f"Error during execute_place: {e}")

    try:
        robot.execute_movement(mode=8)  # Move to ready pose after place
    except Exception:
        pass

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()