from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up dice1 from ready-pose (axis=2 for general object pick)
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Go to ready pose before pick (optional safety)
        robot.execute_movement(Object["drawer_top_handle"], mode=8)      # Go to ready pose before pick (optional safety)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick: {e}")

    try:
        # Step 2: Place dice1 into drawer1 at ready-pose (axis=2 for general object place)
        robot.execute_movement(mode=8)  # Go to ready pose before place (optional safety)
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()