from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from current location to dice1 location
        robot.execute_movement(Object["dice1"], mode=7)

        # Step 2: Pick up dice1 at dice1 location (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 3: Move from dice1 location to open drawer location (drawer_top_place_left)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # Step 4: Place dice1 into open drawer at open drawer location (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 5: Move from open drawer location to dice2 location
        robot.execute_movement(Object["dice2"], mode=7)

        # Step 6: Pick up dice2 at dice2 location (approach along z-axis)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)

        # Step 7: Move from dice2 location to open drawer location (drawer_top_place_right)
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)

        # Step 8: Place dice2 into open drawer at open drawer location (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()