from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Turn on the light (execute_push_switch)
    robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)

    # Step 2: Pick up dice1 from ready-pose
    try:
        if "dice1" in Object:
            # Approach dice1 along z-axis (axis=2) for picking
            robot.execute_movement(Object["dice1"], mode=1, axis=2)
        else:
            print("Warning: dice1 not found in Object list.")
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 3: Place dice1 into the open drawer at ready-pose
    # According to the object list and typical mapping, use "drawer_top_place_left" as the place target for the open drawer
    try:
        if "drawer_top_place_left" in Object:
            robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        else:
            print("Warning: drawer_top_place_left not found in Object list.")
    except Exception as e:
        print(f"Error during execute_place for dice1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()