from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: (execute_push_switch light_switch ready-pose)
    # There is no direct skill for execute_push_switch in the provided skills.
    # We assume the light is already on or this step is handled outside the available skills.

    # Step 2: (execute_pick dice1 ready-pose)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 3: (execute_place dice1 drawer1 ready-pose)
    # Since "drawer1" is not in the object list, we map it to the top drawer's place location.
    # We'll use "drawer_top_place_left" as the placement location.
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()