from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Turn on the light (execute_push_switch) ===
    try:
        # The light switch is at Object["light_switch"], approach along z-axis (axis=2)
        # Use mode=1 (execute_pick) to simulate pushing the switch if no direct skill, but here we use execute_movement for the switch
        # Since execute_push_switch is not directly mapped, we use pick on the switch to simulate the push
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_push_switch for light_switch: {e}")

    # === Step 2: Pick up dice1 ===
    try:
        # For general objects, approach along the z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # === Step 3: Place dice1 into the open drawer ===
    try:
        # The open drawer is assumed to be the top drawer, place at left position
        # Approach along the z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into drawer: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()