from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light (execute_push_switch)
        # There is no direct skill for execute_push_switch, but the plan requires it.
        # We use the gripper skill to simulate pushing the light switch if needed.
        # However, only execute_pick and execute_place are required by the specification.
        # If the environment requires the light to be on, ensure it is on before proceeding.
        # If the robot must interact with the light switch, you would use:
        # robot.execute_movement(Object["light_switch"], mode=1, axis=2)  # pick (if needed)
        # robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)  # push (if needed)
        # But per the specification, only execute_pick and execute_place are to be used.

        # Step 2: Pick up dice1 from ready-pose (axis=2 for general objects)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 3: Place dice1 into the already open drawer at ready-pose (axis=2 for general objects)
        # The plan uses "drawer1" and "ready-pose". We map this to a known drawer place location.
        # We'll use "drawer_top_place_left" as the standard place for the open drawer.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()