from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 0: Turn on the light (execute_push_switch)
        # There is no direct skill for execute_push_switch, so we simulate pressing the light switch.
        # Use pick skill to press the switch (approach along z-axis: axis=2)
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose (release)

        # Step 1: Pick up dice1 at ready-pose (execute_pick)
        # Approach along z-axis (axis=2) for general objects
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose (release)

        # Step 2: Place dice1 into the open drawer at ready-pose (execute_place)
        # Place at drawer_top_place_left (assumed open drawer location)
        # Approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose (release)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()