from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light (execute_push_switch)
        # There is no direct skill for execute_push_switch, so we simulate it by picking (pushing) the light switch.
        # Approach along z-axis for general object (light_switch).
        robot.execute_movement(Object["light_switch"], mode=1, axis=2)

        # Step 2: Pick up dice1 at ready-pose (axis=2 for general object pick)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 3: Place dice1 into drawer1 at ready-pose (axis=2 for general object place)
        # Use drawer_top_place_left as the place location for drawer1.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()