from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Put a single dice in the already open drawer.
    """
    robot = RobotController()
    try:
        # Step 1: Turn on the light if the room is dark
        robot.execute_movement(Object["light_switch"], mode=5)  # execute_push_switch

        # Step 2: Pick up any dice (choose dice1 as representative)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 3: Place the dice into the already open drawer (drawer1)
        robot.execute_movement(Object["drawer1"], mode=2, axis=2)  # execute_place

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()