"""Module to store a dice in the open drawer using robot skills."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store a dice in the open drawer."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_movement(Object["light_switch"], mode=9)

    # Step 2: Pick up any dice from the floor
    # Select the first available dice on the floor
    dice_candidates = ["yellow_dice", "red_dice", "blue_dice", "dice1", "dice2"]
    dice_to_pick = None
    for dice_name in dice_candidates:
        if dice_name in Object:
            dice_to_pick = Object[dice_name]
            break
    if dice_to_pick is None:
        return

    robot.execute_movement(Object["trash"], mode=8)
    robot.execute_movement(dice_to_pick, mode=1, axis=2)

    # Step 3: Place the dice into any open drawer
    open_drawer_places = [
        "drawer_top_place_left",
        "drawer_top_place_middle",
        "drawer_top_place_right"
    ]
    drawer_place = None
    for place_name in open_drawer_places:
        if place_name in Object:
            drawer_place = Object[place_name]
            break
    if drawer_place is None:
        return

    robot.execute_movement(mode=8)
    robot.execute_movement(drawer_place, mode=2, axis=2)

def main():
    """Main function to execute the task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()