from Object_list import Object
from skill_mapping import RobotController

def move_one_dice_to_open_drawer():
    """
    Move one dice to the drawer that's already open.
    Preconditions:
        - At least one dice is on the floor.
        - At least one drawer is already open.
        - The room may be dark; if so, turn on the light first.
    """
    robot = RobotController()

    # Step 1: Ensure the room is bright (turn on the light if needed)
    if not robot.is_room_bright():
        robot.execute_push_switch(Object["light_switch"], Object["ready_pose"])

    # Step 2: Find one dice on the floor
    dice_candidates = [obj for obj in ["dice1", "dice2"] if robot.is_on_floor(obj)]
    if not dice_candidates:
        raise RuntimeError("No dice found on the floor.")
    dice = dice_candidates[0]

    # Step 3: Find an already open drawer
    open_drawers = [d for d in ["drawer1", "drawer2", "drawer3"] if robot.is_drawer_open(d)]
    if not open_drawers:
        raise RuntimeError("No open drawer found.")
    target_drawer = open_drawers[0]

    # Step 4: Move to the dice location (assume ready_pose for this problem)
    if not robot.is_at_location(Object["ready_pose"]):
        robot.execute_movement(Object["ready_pose"], mode=8)

    # Step 5: Pick up the dice
    robot.execute_pick(dice, Object["ready_pose"])

    # Step 6: Move to the open drawer location (assume ready_pose for this problem)
    if not robot.is_at_location(Object["ready_pose"]):
        robot.execute_movement(Object["ready_pose"], mode=8)

    # Step 7: Place the dice into the open drawer
    robot.execute_place(dice, target_drawer, Object["ready_pose"])

def main():
    move_one_dice_to_open_drawer()

if __name__ == "__main__":
    main()