from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Insert one dice into the drawer that is open.
    """
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_movement(Object["light_switch"], mode=3, axis=0)

    # Step 2: Find any dice on the floor
    dice = None
    for dice_name in ["dice1", "dice2"]:
        if Object[dice_name].on_floor:
            dice = Object[dice_name]
            break

    # Step 3: Find any open drawer
    open_drawer = None
    for drawer_name in ["drawer1", "drawer2", "drawer3"]:
        if Object[drawer_name].is_open:
            open_drawer = Object[drawer_name]
            break

    # Step 4: Pick up the dice
    if dice is not None:
        robot.execute_movement(dice, mode=1, axis=2)

    # Step 5: Place the dice into the open drawer
    if open_drawer is not None:
        place_location = open_drawer.top_place_location
        robot.execute_movement(place_location, mode=2, axis=2)

def main():
    """
    Main function to execute the long horizon task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()