"""Module to store a dice in the open drawer, ensuring light is on and using any available dice and open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Store a dice in the open drawer, turning on the light if needed."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    try:
        robot.execute_movement(Object["light_switch"], mode=3, axis=0)
    except Exception as error:
        print(f"Error during execute_push_switch for light: {error}")

    # Step 2: Pick any available dice (dice1 or dice2)
    dice_obj = None
    if "dice1" in Object:
        dice_obj = Object["dice1"]
    elif "dice2" in Object:
        dice_obj = Object["dice2"]
    else:
        print("No dice found to pick.")
        return

    try:
        robot.execute_movement(dice_obj, mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick for dice: {error}")

    # Step 3: Place the dice in any open drawer (drawer1 is open in initial state)
    drawer_place_obj = None
    if "drawer1" in Object and "drawer1_place" in Object:
        drawer_place_obj = Object["drawer1_place"]
    elif "drawer2" in Object and "drawer2_place" in Object:
        drawer_place_obj = Object["drawer2_place"]
    elif "drawer3" in Object and "drawer3_place" in Object:
        drawer_place_obj = Object["drawer3_place"]
    else:
        # Fallback to any known open drawer place
        for key in Object:
            if "drawer" in key and "place" in key:
                drawer_place_obj = Object[key]
                break
    if drawer_place_obj is None:
        print("No open drawer found to place the dice.")
        return

    try:
        robot.execute_movement(drawer_place_obj, mode=2, axis=2)
    except Exception as error:
        print(f"Error during execute_place for dice: {error}")

def main():
    """Main entry point to execute the dice storing task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()