"""Module to move one dice to the open drawer, ensuring all domain preconditions are satisfied."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Moves one dice to the open drawer, turning on the light and moving as needed."""
    robot = RobotController()

    # Step 1: Move to the light switch location and turn on the light
    robot.execute_movement(Object["ready_to_switch"], mode=0, axis=0)  # Move to light switch location
    robot.execute_push_switch(Object["light_switch"], Object["ready_to_switch"])  # Turn on the light

    # Step 2: Move to the floor location
    robot.execute_movement(Object["ready_to_floor"], mode=0, axis=0)  # Move to floor

    # Step 3: Pick up one dice from the floor (choose dice1)
    robot.execute_pick(Object["dice1"], Object["ready_to_floor"])  # Pick up dice1

    # Step 4: Move to the drawer area
    robot.execute_movement(Object["ready_to_drawer"], mode=0, axis=0)  # Move to drawer-area

    # Step 5: Place dice1 into the open drawer1
    robot.execute_place(Object["dice1"], Object["drawer1"], Object["ready_to_drawer"])  # Place dice1 in drawer1

def main():
    """Main entry point for the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()