from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Place one dice into the open drawer.
    """
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_movement(Object["light_switch"], mode=3, axis=0)

    # Step 2: Pick up any dice on the floor (choose the first available)
    dice_to_pick = None
    for dice_name in ["dice1", "dice2"]:
        if Object.get(dice_name):
            dice_to_pick = Object[dice_name]
            break
    if dice_to_pick is None:
        print("No dice found to pick.")
        return

    robot.execute_movement(dice_to_pick, mode=1, axis=2)

    # Step 3: Place the dice into the open drawer (drawer1 is open in the initial state)
    if Object.get("drawer1"):
        robot.execute_movement(Object["drawer1"], mode=2, axis=2)
    else:
        print("No open drawer found to place the dice.")

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()