from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one dice into the open drawer that is open, ensuring all domain preconditions are met."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Pick up dice1 from the floor at ready-pose
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 3: Place dice1 into the open drawer1 at ready-pose
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

def main():
    """Main entry point for the task execution."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()