from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Move one dice to the drawer that's already open (drawer1).
    Steps:
    1. Turn on the light if the room is dark.
    2. Move to ready-pose if not already there.
    3. Pick up one dice (dice1 or dice2) from the floor at ready-pose.
    4. Place the dice into drawer1 at ready-pose.
    """
    robot = RobotController()

    # Step 1: Turn on the light
    robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Ensure robot is at ready-pose (if not, move there)
    robot.execute_go(Object["ready-pose"], Object["ready-pose"])

    # Step 3: Select one dice on the floor
    dice_to_move = None
    for dice_name in ["dice1", "dice2"]:
        if robot.is_on_floor(Object[dice_name]):
            dice_to_move = Object[dice_name]
            break
    if dice_to_move is None:
        print("No dice found on the floor to move.")
        return

    # Step 4: Pick up the dice
    robot.execute_pick(dice_to_move, Object["ready-pose"])

    # Step 5: Place the dice into the open drawer (drawer1)
    robot.execute_place(dice_to_move, Object["drawer1"], Object["ready-pose"])

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()