from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Place one dice into the open drawer, following domain preconditions.
    """
    robot = RobotController()

    try:
        # Step 1: If the room is dark, turn on the light using the switch at ready-pose
        if robot.get_room_light_state() == "dark":
            robot.execute_movement(Object["light_switch"], mode=6, axis=2)  # Push switch to turn on light

        # Step 2: Move to the location of dice1 (assume it's on the floor)
        robot.execute_movement(Object["floor"], mode=7)  # Move to floor

        # Step 3: Pick up dice1 from the floor
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # Pick from above

        # Step 4: Move to the location of the open drawer1 (assume it's at drawer-area)
        robot.execute_movement(Object["drawer-area"], mode=7)  # Move to drawer-area

        # Step 5: Place dice1 into drawer1 (assume left/top place position)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # Place from above

        # Step 6: Return to ready pose
        robot.execute_movement(mode=8)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """
    Main entry point for the task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()