from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Put a single dice in the already open drawer.
    Ensures the light is on, finds any dice on the floor, and any open drawer.
    """
    robot = RobotController()

    # Step 1: Turn on the light if needed
    if robot.is_room_dark():
        robot.execute_push_switch(Object["light_switch"], Object["ready-pose"])

    # Step 2: Find a dice on the floor
    dice_candidates = [name for name in Object if name.startswith("dice") and robot.is_on_floor(Object[name])]
    if not dice_candidates:
        print("No dice found on the floor.")
        return
    dice_to_pick = dice_candidates[0]

    # Step 3: Find an open, not full drawer
    open_drawers = [name for name in Object if name.startswith("drawer") and robot.is_drawer_open(Object[name]) and not robot.is_drawer_full(Object[name])]
    if not open_drawers:
        print("No open drawer available.")
        return
    target_drawer = open_drawers[0]

    # Step 4: Move to the dice location if not already there
    dice_location = robot.get_object_location(Object[dice_to_pick])
    if not robot.is_at_location(dice_location):
        robot.execute_go(robot.get_robot_location(), dice_location)

    # Step 5: Pick up the dice
    robot.execute_movement(Object[dice_to_pick], mode=1, axis=2)

    # Step 6: Move to the drawer area if not already there
    drawer_location = robot.get_drawer_area(Object[target_drawer])
    if not robot.is_at_location(drawer_location):
        robot.execute_go(robot.get_robot_location(), drawer_location)

    # Step 7: Place the dice in the open drawer
    robot.execute_movement(Object[target_drawer], mode=2, axis=2)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()