"""Module to insert one dice into the open drawer, ensuring all domain preconditions are satisfied."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one dice into the open drawer that is open, following domain preconditions."""
    robot = RobotController()

    # Step 1: Turn on the light if the room is dark
    robot.execute_movement(Object["light_switch"], mode=3, axis=0)

    # Step 2: Pick up any available dice from the floor at ready-pose
    dice_candidates = ["dice1", "dice2"]
    picked_dice = None
    for dice_name in dice_candidates:
        try:
            robot.execute_movement(Object[dice_name], mode=1, axis=2)
            picked_dice = dice_name
            break
        except Exception:
            continue

    if picked_dice is None:
        return

    # Step 3: Place the dice into the open drawer at ready-pose
    open_drawer_candidates = ["drawer1", "drawer2", "drawer3"]
    for drawer_name in open_drawer_candidates:
        if Object[drawer_name]["state"] == "open":
            place_target = Object[f"{drawer_name}_top_place_left"]
            try:
                robot.execute_movement(place_target, mode=2, axis=2)
                break
            except Exception:
                continue

def main():
    """Main entry point to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()