"""Module to store a dice in the open drawer, following domain and observation constraints."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store dice1 in the open drawer1, satisfying all domain preconditions."""
    robot = RobotController()

    # Initial state from observation
    # - Robot at 'ready-pose'
    # - Room is dark
    # - dice1 is on the floor
    # - drawer1 is open, unlocked, empty

    # Step 1: If room is dark, turn on the light
    if robot.get_room_light_state() == "dark":
        robot.move_to_location("ready-pose")
        robot.execute_push_switch(Object["light_switch"], "ready-pose")

    # Step 2: Move to floor to pick up dice1
    robot.move_to_location("floor")

    # Step 3: Pick up dice1 from the floor
    if robot.is_hand_empty() and robot.get_room_light_state() == "bright":
        robot.execute_pick(Object["dice1"], "floor")
    else:
        raise RuntimeError("Cannot pick up dice1: hand not empty or room not bright.")

    # Step 4: Move to drawer-area to place dice1
    robot.move_to_location("drawer-area")

    # Step 5: Ensure drawer1 is open and not full
    if not robot.is_drawer_open("drawer1"):
        # If drawer is closed and unlocked, open it using handle1
        if robot.is_drawer_unlocked("drawer1"):
            if robot.is_hand_empty():
                robot.execute_pick(Object["handle1"], "floor")
            robot.execute_pull("drawer1", Object["handle1"], "drawer-area")
        else:
            raise RuntimeError("Drawer1 is locked and cannot be opened.")

    if robot.is_drawer_full("drawer1"):
        raise RuntimeError("Drawer1 is full and cannot accept more items.")

    # Step 6: Place dice1 into drawer1
    if robot.is_holding("dice1") and robot.is_drawer_open("drawer1") and not robot.is_drawer_full("drawer1"):
        robot.execute_place(Object["dice1"], "drawer1", "drawer-area")
    else:
        raise RuntimeError("Cannot place dice1: preconditions not met.")

def main():
    """Main entry point to execute the dice storing task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()