from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Move one dice to the drawer that's already open, ensuring all preconditions are met.
    """
    robot = RobotController()

    # List of dice objects
    dice_candidates = ["dice1", "dice2"]
    open_drawer = "drawer1"
    robot_location = robot.get_current_location()
    ready_pose = "ready-pose"

    # Ensure the room is bright
    if not robot.is_room_bright():
        robot.execute_push_switch(Object["light_switch"], ready_pose)

    # Move to ready-pose if not already there
    if robot_location != ready_pose:
        robot.execute_go(robot_location, ready_pose)

    # Select a dice that is on the floor
    dice_to_move = None
    for dice in dice_candidates:
        if robot.is_on_floor(Object[dice]):
            dice_to_move = dice
            break

    if dice_to_move is None:
        print("No dice available on the floor to move.")
        return

    # Pick up the dice
    robot.execute_pick(Object[dice_to_move], ready_pose)

    # Place the dice into the open drawer
    robot.execute_place(Object[dice_to_move], Object[open_drawer], ready_pose)

def main():
    """
    Main entry point for the task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()