# run_skeleton_task.py (Completed with Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback indicates (drawer-closed drawer1) is missing or needs to be explored.
        # We will use available skills to explore the state of drawer1.

        # Assumptions for object names and locations
        # You may need to adjust these names based on your environment
        drawer_name = 'drawer1'
        handle_name = 'handle1'
        robot_location = 'loc_robot'
        drawer_location = 'loc_drawer'
        # The actual names/keys should match those in your environment and object_positions

        # Try to get actual positions if available
        try:
            drawer_pos = positions.get(drawer_name, None)
            handle_pos = positions.get(handle_name, None)
            robot_pos = positions.get('robot', None)
        except Exception as e:
            print("[Exploration] Could not retrieve positions from object_positions:", e)
            drawer_pos = None
            handle_pos = None
            robot_pos = None

        # Step 1: Move robot to drawer location if not already there
        try:
            # If robot is not at drawer location, move it
            # This assumes you have a way to get current robot location and drawer location
            # For demonstration, we use placeholder names
            obs, reward, done = execute_go(
                env,
                task,
                from_location=robot_location,
                to_location=drawer_location
            )
            print(f"[Exploration] Robot moved from {robot_location} to {drawer_location}")
        except Exception as e:
            print("[Exploration] Error during execute_go:", e)

        # Step 2: Try to pull the drawer to check if it is closed/locked/unlocked
        # This will help us determine the missing predicate (drawer-closed)
        try:
            # First, pick the handle if required
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=handle_name,
                location=drawer_location
            )
            print(f"[Exploration] Picked handle: {handle_name} at {drawer_location}")
        except Exception as e:
            print("[Exploration] Error during execute_pick (handle):", e)

        try:
            # Now, try to pull the drawer using the handle
            obs, reward, done = execute_pull(
                env,
                task,
                drawer_name=drawer_name,
                handle_name=handle_name,
                location=drawer_location
            )
            print(f"[Exploration] Attempted to pull {drawer_name} using {handle_name} at {drawer_location}")
        except Exception as e:
            print("[Exploration] Error during execute_pull (drawer):", e)

        # Step 3: Check if the drawer is now open or if the action failed (indicating it was closed/locked)
        # This is where you would check the observation or environment state for the predicate
        # For demonstration, we print the feedback
        print("[Exploration] Feedback: (drawer-closed drawer1)")

        # === Main Task Plan ===
        # After exploration, proceed with the main plan using available skills
        # Example: Open the drawer, place an object, close the drawer

        # Step 4: If drawer is open, place an object inside
        object_to_place = 'object1'  # Replace with actual object name
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=object_to_place,
                location=drawer_location
            )
            print(f"[Task] Picked up {object_to_place} at {drawer_location}")
        except Exception as e:
            print("[Task] Error during execute_pick (object):", e)

        try:
            obs, reward, done = execute_place(
                env,
                task,
                object_name=object_to_place,
                drawer_name=drawer_name,
                location=drawer_location
            )
            print(f"[Task] Placed {object_to_place} in {drawer_name} at {drawer_location}")
        except Exception as e:
            print("[Task] Error during execute_place:", e)

        # Step 5: Close the drawer
        try:
            obs, reward, done = execute_push(
                env,
                task,
                drawer_name=drawer_name,
                location=drawer_location
            )
            print(f"[Task] Closed {drawer_name} at {drawer_location}")
        except Exception as e:
            print("[Task] Error during execute_push:", e)

        # === End of Task ===

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
