from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle of the bottom drawer (execute_pick)
        # According to the axis convention: handle grasping -> axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Pull open the bottom drawer (execute_pull)
        # execute_pull: mode=4, axis=0 (x-axis), distance can be default or set (e.g., 0.1)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()