from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick(handle_bottom, ...)
    # According to the axis convention: for handles, use axis=0 (x-axis approach)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    # Step 2: execute_pull(drawer_bottom, handle_bottom, ...)
    # For pulling a drawer, use axis=0 (x-axis approach), and a reasonable pull distance (e.g., 0.1)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()