from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: execute_pick(handle_bottom, ready-pose)
        #   - handle_bottom corresponds to Object["drawer_bottom_handle"]
        #   - Approach handle along x-axis => axis=0
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        
        # Step 2: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        #   - Pull handle (drawer_bottom) with handle_bottom at ready-pose
        #   - mode=4 for execute_pull, approach along x-axis, distance=0.1
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        
    except KeyError as e:
        print(f"Object key error: {e}. Please check the Object list mapping.")
    except Exception as exc:
        print(f"Exception during plan execution: {exc}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()