from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick up the handle_bottom at ready-pose (execute_pick)
    # For handles, approach axis=0 (x-axis)
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick on drawer_bottom_handle: {e}")

    # Step 2: Pull the drawer_bottom using handle_bottom at ready-pose (execute_pull)
    # For pulling, approach axis=0 (x-axis), use a slightly larger distance for drawer opening
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error during execute_pull on drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()