from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light switch (execute_push_switch)
        # No direct skill for execute_push_switch, but we can use execute_movement with mode=3 (push) on the light switch.
        # Since the light switch is at ready-pose, we use axis=0 (x-axis) for pushing a switch.
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=0, distance=0.03)

        # Step 2: Pick up the handle_bottom (approach along x-axis for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the drawer using the handle (execute_pull, approach along x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()