from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_push_switch(light_switch, ready-pose)
        # Turn on the light (required precondition for all subsequent actions)
        robot.execute_movement(Object["ready-pose"], mode=8)  # Move to ready pose if needed
        robot.primitive_skill.execute_push_switch("light_switch", "ready-pose")

        # Step 2: execute_pick(handle_bottom, ready-pose)
        # [Frozen Code Start]
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=0)
        # [Frozen Code End]

        # Step 3: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # Pull the drawer open using the handle
        robot.execute_movement(Object["handle_bottom"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()