from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle_bottom, ready-pose)
        # Pick up the handle_bottom at ready-pose. For handles, approach along x-axis (axis=0).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick for drawer_bottom_handle: {e}")

    try:
        # Step 2: execute_push_swtich(light_switch, ready-pose)
        # Turn on the light switch at ready-pose. Use mode=3 (push), approach along z-axis (axis=2).
        # The skill name in available skills is 'execute_push_swtich -> push', so use mode=3.
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=2)
    except Exception as e:
        print(f"Error in execute_push_swtich for light_switch: {e}")

    try:
        # Step 3: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # Pull open the drawer_bottom using handle_bottom at ready-pose. For handles, approach along x-axis (axis=0).
        # Use mode=4 (pull), and set a reasonable distance for pulling (e.g., 0.1).
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error in execute_pull for drawer_bottom_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()