from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Turn on the light (execute_push_switch)
        # The plan specifies to push the light switch at ready-pose.
        # We'll use mode=3 (push) for the switch, approach along x-axis (axis=0), small distance.
        robot.execute_movement(Object["light_switch"], mode=3, axis=0, distance=0.02)

        # Step 2: Pick up the bottom drawer handle (execute_pick)
        # Use handle_bottom, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the bottom drawer open (execute_pull)
        # Use handle_bottom to pull drawer_bottom, approach along x-axis (axis=0), longer distance for pull
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()