from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Push the light switch at ready-pose to turn on the light
        # execute_push_switch(light_switch, ready-pose)
        # Use mode=3 (push), axis=2 (arbitrary for switch)
        robot.execute_movement(Object["light_switch"], mode=3, axis=2)
    except Exception as e:
        print(f"Error in execute_push_switch (light_switch): {e}")

    try:
        # Step 2: Pick up the handle_bottom at ready-pose
        # execute_pick(handle_bottom, ready-pose)
        # Use mode=1 (pick), axis=0 (for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick (drawer_bottom_handle): {e}")

    try:
        # Step 3: Pull open the drawer_bottom using handle_bottom at ready-pose
        # execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # Use mode=4 (pull), axis=0 (for handle), distance=0.1
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull (drawer_bottom_handle): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()