from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the handle_bottom at ready-pose (execute_pick)
        # For handles, approach axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: Push the light switch at ready-pose (execute_push)
        # For switches, approach axis=0 (x-axis)
        robot.execute_movement(Object["light_switch"], mode=3, axis=0, distance=0.05)

        # Step 3: Pull the drawer_bottom using handle_bottom at ready-pose (execute_pull)
        # For handles, approach axis=0 (x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()