from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: execute_push_switch(light_switch, ready-pose)
        # The light switch is likely a button, so use push (mode=3), approach along z-axis (axis=2)
        robot.execute_movement(Object.get("light_switch", None), mode=3, axis=2, distance=0.03)

        # Step 2: execute_pick(handle_bottom, ready-pose)
        # Pick up the bottom drawer handle, approach along x-axis (axis=0)
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=1, axis=0)

        # Step 3: execute_pull(drawer_bottom, handle_bottom, ready-pose)
        # Pull the bottom drawer open, approach along x-axis (axis=0), use a longer distance for pulling
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()