from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Turn on the light (execute_push_switch)
        # There is no direct skill for execute_push_switch, but according to the skill mapping,
        # we can use mode=3 (push) on the light switch to simulate pushing the switch.
        # However, the available object list does not include "light_switch", so we skip the pose.
        # If Object["light_switch"] is not available, we handle gracefully.
        if "light_switch" in Object:
            robot.execute_movement(Object["light_switch"], mode=3, axis=2, distance=0.03)
        else:
            print("Warning: light_switch object not found in Object list. Skipping light switch push.")

        # Step 2: Pick the handle of the bottom drawer (axis=0 for handle grasp)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull open the bottom drawer (mode=4, axis=0, distance=0.1 for drawer pull)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()